function criar_campos(id, tipo) {

    var input = document.createElement("input");
    input.type = tipo;
    input.id = id;
    input.value = "";
    return input;
}

window.onload = function() {

    // Cria os campos ocultos para uso nas funções
    document.body.appendChild(criar_campos("idValor", "hidden"));
    document.body.appendChild(criar_campos("id,", "hidden"));
    document.body.appendChild(criar_campos("idPeriodo", "hidden"));

}

function set_total() {

    var idValor = parseFloat(document.getElementById("idValor").value);
    var idDesconto_Acrescimo = parseFloat(document.getElementById("idDesconto_Acrescimo").value);
    var idPeriodo = parseFloat(document.getElementById("idPeriodo").value);

    var total = 0;

    total = parseFloat(idValor);

    if (idPeriodo > 1) {

        total = parseFloat(total * idPeriodo);

    }

    if (idDesconto_Acrescimo != "" && !isNaN(idDesconto_Acrescimo)) {
        total = parseFloat(total + idDesconto_Acrescimo);
    }

    document.getElementById("valor").value = total;

    // Debug
   // alert("Valor: " + total);

    number_format("div_valor", total);

}

function pesquisar_dominio(dominio) {

    if (dominio) {

        document.getElementById('div_status_dominio').innerHTML = "<img src='img/spinner.gif' />";

        var http = new Ajax();
        http.open("GET", "inc/funcoes.ajax.php?acao=pesquisar_dominio_whois&dominio=" + dominio, true);
        http.onreadystatechange = function() {

            if (http.readyState == 4) {
                resultado = http.responseText;
                if (resultado == "1") {

                    document.getElementById('div_status_dominio').innerHTML = "<i class=\"material-icons mdl-color-text--orange\" style='vertical_align: bottom'>&#xE002;</i>";

                    alert("Whois: O domínio " + dominio + " já esta registrado.\nEsta mensagem é apenas informativa.");

                } else {
                    document.getElementById('div_status_dominio').innerHTML = "<i class=\"material-icons mdl-color-text--green\" style='vertical_align: bottom'>&#xE876;</i>";

                    alert("Whois: O domínio " + dominio + " esta livre para registro.\nEsta mensagem é apenas informativa.");
                }
            }
        }
        http.send(null);
        delete http;
    }
}

function pesquisar_extensao_valor(codigo) {

    if (codigo != "") {

        document.getElementById('div_valor').innerHTML = "<img src='img/spinner.gif' />";

        var http = new Ajax();
        http.open("GET", "inc/funcoes.ajax.php?acao=pesquisar_extensao_valor&codigo=" + codigo, true);
        http.onreadystatechange = function() {

            if (http.readyState == 4) {
                valor = http.responseText;

                // Grava os campos principais com os dados do plano
                document.getElementById("idValor").value = valor;
                console.log(valor + " = valor");
                set_total();

            }
        }
    }
    http.send(null);
    delete http;
}

function pesquisar_periodo_registro(periodo) {

    document.getElementById('div_valor').innerHTML = "<img src='img/spinner.gif' />";

    if (periodo) {

        document.getElementById("idPeriodo").value = periodo;

        set_total();

    }

}

function number_format(div, valor) {

    var http = new Ajax();
    http.open("GET", "inc/funcoes.ajax.php?acao=number_format&valor=" + valor, true);
    http.onreadystatechange = function() {

        if (http.readyState == 4) {
            resultado = http.responseText;

            if (resultado) {
                document.getElementById(div).innerHTML = resultado;
            }
        }
    }
    http.send(null);
    delete http;
}

function desconto_acrescimo(valor) {

    if (valor != "") {

        document.getElementById('div_valor').innerHTML = "<img src='img/spinner.gif' />";

        valor = valor.replace(".", "");
        valor = valor.replace(",", ".");

        document.getElementById("idDesconto_Acrescimo").value = parseFloat(valor);

        set_total();
    } else {

        document.getElementById('div_valor').innerHTML = "<img src='img/spinner.gif' />";
        document.getElementById("idDesconto_Acrescimo").value = 0;

        set_total();
    }
}

function Ajax() {
    var req;

    try {
        req = new ActiveXObject("Microsoft.XMLHTTP");
    } catch (e) {
        try {
            req = new ActiveXObject("Msxml2.XMLHTTP");
        } catch (ex) {
            try {
                req = new XMLHttpRequest();
            } catch (exc) {
                alert("Esse browser não tem recursos para uso do Ajax");
                req = null;
            }
        }
    }

    return req;
}