#!/bin/bash
if [ -f /etc/lsb-release ]; then
    # For some versions of Debian/Ubuntu without lsb_release command
    . /etc/lsb-release
    OS=$DISTRIB_ID
    VER=$DISTRIB_RELEASE
elif [ -f /etc/debian_version ]; then
# Older Debian/Ubuntu/etc.
    OS=Debian
    VER=$(cat /etc/debian_version)
elif [ -f /etc/os-release ]; then
    # freedesktop.org and systemd
    . /etc/os-release
    OS=$NAME
    VER=$VERSION_ID
    if [[ "$OS" == "CentOS Linux" ]]; then
        OS=CentOS
    fi
elif [ -f /etc/SuSe-release ]; then
    # Older SuSE/etc.
    OS=Suse
elif [ -f /etc/redhat-release ]; then
    # Older Red Hat, CentOS, etc.
    OS=Centos
    VER=$(cat /etc/centos-release)
elif type lsb_release >/dev/null 2>&1; then
    # linuxbase.org
    OS=$(lsb_release -si)
    VER=$(lsb_release -sr)
else
    # Fall back to uname, e.g. "Linux <version>", also works for BSD, etc.
    OS=$(uname -s)
    VER=$(uname -r)
fi

VER=$(echo $VER | cut -d '.' -f 1)

if [[ "$OS" == "Debian" && "$VER" == "11" ]]; then
      echo "ls" && echo -e "$4\n$4" | passwd root && echo "allow-hotplug ens192
iface ens192 inet static
	address $2/24
	gateway 143.208.9.1
	# dns-* options are implemented by the resolvconf package, if installed
	dns-nameservers 8.8.8.8 189.38.95.95 1.1.1.1" > /etc/network/interfaces && echo "systemctl restart networking" && reboot 

fi

if [[ "$OS" == "Ubuntu" && "$VER" == "22" ]]; then
      echo -e "$4\n$4" | passwd root  &&  cd /etc/netplan && mv *.yaml 02-vmware-cloud-init.yaml && sed -i "s/$1/$2/g" /etc/netplan/02-vmware-cloud-init.yaml && echo $4 && netplan apply && rm -f $3 && sudo -i && reboot
fi
ll
if [[ "$OS" == "Ubuntu" && "$VER" == "18" ]]; then
    echo -e "$4\n$4" | passwd root  &&  cd /etc/netplan && mv *.yaml 02-vmware-cloud-init.yaml && sed -i "s/$1/$2/g" /etc/netplan/02-vmware-cloud-init.yaml && echo $4 && netplan apply && rm -f $3 && sudo -i && reboot
fi

if [[ "$OS" == "Ubuntu" && "$VER" == "16" ]]; then
    echo root:$4 | chpasswd && sed -i "s/$1/$2/g" /etc/network/interfaces && echo $4 && rm -f $3 && reboot
fi

if [[ "$OS" == "CentOS" && "$VER" == "7" ]]; then
    iname=$(ip -o link show | sed -rn '/^[0-9]+: en/{s/.: ([^:]*):.*/\1/p}')

    echo -e "$4\n$4" | passwd root && sed -i "s/$1/$2/g" /etc/sysconfig/network-scripts/ifcfg-$iname && echo $4 && rm -f $3 && reboot
fi